--ͳ
CREATE PROCEDURE sp_DiseaseGrpstats
    @ModalityType varchar(18), 
    @StatStartDttm datetime,
    @StatEndDttm datetime 
AS
BEGIN
 
DECLARE @sStudy_dttm datetime 
DECLARE @iStudy_key int
DECLARE @sGroupName varchar(128)
DECLARE @sGroupNameChild varchar(128)
DECLARE @iPos int
DECLARE @ilen int


DECLARE crStudy CURSOR FOR

SELECT study_dttm, study_key, report_diseasename 
FROM study
WHERE study_modalitytype=@ModalityType AND report_state > 0 AND
	study_dttm >= @StatStartDttm AND study_dttm <= @StatEndDttm 

OPEN crStudy

FETCH NEXT FROM crStudy 
INTO @sStudy_dttm,@iStudy_key,@sGroupName 

WHILE @@FETCH_STATUS = 0
BEGIN
  SET @sGroupName=RTRIM(LTRIM(@sGroupName))  
  IF LEN(@sGroupName) > 0
  BEGIN
	  SET @iPos=CHARINDEX(' ',@sGroupName)          
	  WHILE @iPos>=1       
	  BEGIN    
		SET @sGroupNameChild=SUBSTRING(@sGroupName,1,@iPos-1)  
		INSERT INTO CC_Statist (study_dttm,study_key,statist_field)  
			VALUES(@sStudy_dttm,@iStudy_key,@sGroupNameChild)
		SET @iLen=LEN(@sGroupName)  
		SET @sGroupName=SUBSTRING(@sGroupName,@iPos+1,@iLen)  
		SET @sGroupName=RTRIM(LTRIM(@sGroupName))  
		SET @iPos=CHARINDEX(' ',@sGroupName)  
	  END

	  INSERT INTO CC_Statist (study_dttm,study_key,statist_field)    
		VALUES(@sStudy_dttm,@iStudy_key,@sGroupName)    
  END
  	
  FETCH NEXT FROM crStudy 
  INTO @sStudy_dttm,@iStudy_key,@sGroupName 
END       

CLOSE crStudy     
DEALLOCATE crStudy 

END